/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

     Filename:
   $Workfile: CanDl_Api.h
  Last Modification:
   $Author: Evgeny $
   $Modtime: 05.05.2010 13:47 $
   $Revision: 01 $

      Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : no
    rcX          : yes

   Description:

    Can Dl
    api

   Changes:

     Version    Date        Author
        Description
     --------------------------------------------------------------------------


 */

#ifndef CANDL_API_H_
#define CANDL_API_H_


#define CAN_DL_DATA_QUEUE_MAX_ELEM                                     (32)

typedef TLR_RESULT (CALLBACK FAR* PFN_CAN_DL_RX_CALLBACK )(TLR_VOID FAR* pvUsrRsc, CAN_DL_SDU_DATA_IND_T* ptRxFrame, TLR_UINT32 ulRxFrameCnt);
typedef TLR_RESULT (CALLBACK FAR* PFN_CAN_DL_TX_CALLBACK)(TLR_VOID FAR* pvUsrRsc, CAN_DL_SDU_DATA_REQ_T* ptTxFrame, TLR_UINT32 ulStatus );
typedef TLR_RESULT (CALLBACK FAR* PFN_CAN_DL_EVENT_CALLBACK)(TLR_VOID FAR* pvUsrRsc, TLR_UINT32 ulEvent);
typedef TLR_RESULT (CALLBACK FAR* PFN_CAN_DL_BAUD_RATE_CALLBACK)(TLR_VOID FAR* pvUsrRsc, TLR_UINT32 ulBaudrate );

typedef struct CAN_DL_SDU_API_CALLBACKS_Ttag {
  TLR_VOID FAR* pvRxUsrRsc;
  PFN_CAN_DL_RX_CALLBACK fnRxCallback;
  TLR_VOID FAR* pvTxUsrRsc;
  PFN_CAN_DL_TX_CALLBACK fnTxCallback;
  TLR_VOID FAR* pvEventUsrRsc;
  PFN_CAN_DL_EVENT_CALLBACK fnEventCallback;
  TLR_VOID FAR* pvBaudrateUsrRsc;
  PFN_CAN_DL_BAUD_RATE_CALLBACK fnBaudrateCallback;
} CAN_DL_SDU_API_CALLBACKS_T;


TLR_RESULT
CanDlApi_RegisterRxCallback(        TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    PFN_CAN_DL_RX_CALLBACK fnRxCallback,
                                    TLR_VOID FAR* pvUsrRsc );

TLR_RESULT
CanDlApi_RegisterTxCallback(        TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    PFN_CAN_DL_TX_CALLBACK fnTxCallback,
                                    TLR_VOID FAR* pvUsrRsc );

TLR_RESULT
CanDlApi_RegisterTxHighCallback(    TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    PFN_CAN_DL_TX_CALLBACK fnTxHighCallback,
                                    TLR_VOID FAR* pvUsrRsc );

TLR_RESULT
CanDlApi_RegisterEventCallback(     TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    PFN_CAN_DL_EVENT_CALLBACK fnEventCallback,
                                    TLR_VOID FAR* pvUsrRsc );

TLR_RESULT
CanDlApi_RegisterBaudrateCallback(  TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    PFN_CAN_DL_BAUD_RATE_CALLBACK fnBaudrateCallback,
                                    TLR_VOID FAR* pvUsrRsc );

TLR_RESULT
CanDlApi_ApRegister(                TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_AP_REGISTER_REQ_T* ptApRegData,
                                    CAN_DL_SDU_API_CALLBACKS_T* ptApiCallbacks );

TLR_RESULT
CanDlApi_StopReq(                   TLR_HANDLE hCanDlHandle );

TLR_RESULT
CanDlApi_SetPrmReq(                 TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_SET_PRM_REQ_T* ptParameters );

TLR_RESULT
CanDlApi_SetAutoBaudFlags(          TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_SET_AUTOBAUD_FLAGS_REQ_T* ptAutoBaudFlagsData );

TLR_RESULT
CanDlApi_EnableRxIdReq(             TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_ENABLE_RXID_REQ_T* ptRxId,
                                    TLR_UINT32 ulCounter );

TLR_RESULT
CanDlApi_StartReq(                  TLR_HANDLE hCanDlHandle );

TLR_RESULT
CanDlApi_DataReq(                   TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_DATA_REQ_T FAR* ptTxData,
                                    TLR_UINT32 ulNumToSend );

TLR_RESULT
CanDlApi_FastDataReq(               TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_DATA_REQ_T FAR* ptTxData,
                                    TLR_UINT32 ulNumToSend );

TLR_RESULT
CanDlApi_HighPrioDataReq(           TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_DATA_REQ_T FAR* ptTxData,
                                    TLR_UINT32 ulNumToSend );

TLR_RESULT
CanDlApi_TxAbortReq(                TLR_HANDLE hCanDlHandle,
                                    CAN_DL_SDU_TX_ABORT_REQ_T FAR* ptAbortData );

TLR_RESULT
CanDlApi_InitReq(                   TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_INIT_REQ_T* ptInitData );

TLR_RESULT
CanDlApi_EventRes(                  TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_EVENT_RES_T* ptEventData );

TLR_RESULT
CanDlApi_EventAckReq(               TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_EVENT_ACK_REQ_T* ptEventAckData );

TLR_RESULT
CanDlApi_SetFilterReq(              TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_SET_FILTER_REQ_T* ptFilterData );

TLR_RESULT
CanDlApi_DiagReq(                   TLR_HANDLE hCanDlHandle,
                                    CAN_DL_SDU_DIAG_REQ_T FAR* ptDiagData,
                                    TLR_UINT32* pLength );

TLR_RESULT
CanDlApi_DataRes(                   TLR_HANDLE hCanDlHandle,
                                    CAN_DL_SDU_DATA_IND_T* ptRxFrame );

TLR_RESULT
CanDlApi_SetEventsToIndicateReq(    TLR_HANDLE hCanDlHandle,
                                    TLR_HANDLE hIdentHandle,
                                    CAN_DL_SDU_SET_EVENTS_TO_INDICATE_REQ_T* ptAutoBaudFlagsData );


#endif /* CANDL_API_H_ */
